<?php 

require_once get_template_directory().'/template-parts/navbar.php';

function agregar_css_js(){
    wp_enqueue_style( 'style-name', get_stylesheet_uri() );
    wp_enqueue_script( 'script-name', '/wp-content/themes/temabee%2B/style.css', array(), '1.0.0', true );
}

/**
 * Register Custom Navigation Walker
 */
function register_navwalker(){
	require_once get_template_directory() . '/template-parts/navbar.php';
}

add_action( 'after_setup_theme', 'register_navwalker' );
add_action('wp_enqueue_scripts','agregar_css_js');

//registrar menus

if ( ! function_exists( 'mytheme_register_nav_menu' ) ) {
 
    function mytheme_register_nav_menu(){
        register_nav_menus( array(
            'primary_menu' => __( 'Primary Menu', 'text_domain' ),
            'footer_menu'  => __( 'Footer Menu', 'text_domain' ),
            'menu-principal' =>  __( 'Menu Principal', 'text_domain' ),
        ) );
    }
    add_action( 'after_setup_theme', 'mytheme_register_nav_menu', 0 );
}

// Agregar custom logo
function bee_custom_logo_setup() {
    $defaults = array(
    'flex-height' => true,
    'flex-width'  => true,
    'header-text' => array( 'site-title', 'site-description' ),
    );
    add_theme_support( 'custom-logo', $defaults );
   }
   add_action( 'after_setup_theme', 'bee_custom_logo_setup' );


add_filter('walker_nav_menu_start_el','dcms_agregar_descripcion_item_menu',10,4);

function dcms_agregar_descripcion_item_menu($item_output, $item, $depth, $args){
    if(! empty($item->descripcion)){
        return str_replace('</a>','
                                    <div class="col-12 col-lg-12">
                                        <img class="" style="width: 9rem;" src="'.wp_get_attachment_image_url($item->image_producto, 'full').'"></div></a> ', $item_output);
    }

    return $item_output;
}




/**
 * Change the custom logo URL
 */
function my_custom_logo_link() {

	// The logo
    $custom_logo_id = get_theme_mod( 'custom_logo' );

    // If has logo
    if ( $custom_logo_id ) {

    	// Attr
	    $custom_logo_attr = array(
			'class'    => 'custom-logo',
			'itemprop' => 'logo',
        );
        
        $image = wp_get_attachment_image_src( $custom_logo_id , 'full' );
        $src = str_replace('http://localhost/beechile-tema','',$image[0]) ;
        $custom_logo_attr['src'] = $src;

		// Image alt
		$image_alt = get_post_meta( $custom_logo_id, '_wp_attachment_image_alt', true );
		if ( empty( $image_alt ) ) {
			$custom_logo_attr['alt'] = get_bloginfo( 'name', 'display' );
        }
        
        $custom_logo_attr['srcset'] = "";

	    // Get the image
	    $html = sprintf( '<a href="/" class="custom-logo-link" rel="home" itemprop="url">%1$s</a>',
			wp_get_attachment_image( $custom_logo_id, 'full', false, $custom_logo_attr )
		);

	}

	// Return
    return $html;   
}
add_filter( 'get_custom_logo', 'my_custom_logo_link' );